//
//  MCStageSyncClient.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-08.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCDatabaseSyncDaemon.h>


#define StageDaemon ((MCStageSyncDaemon *)[MCPGDaemon daemon])

@class MCClientStage;
@class MCExportRule;
@class MCPDataStore;
@class MCSyncHost;
@class MCPEntity;
@class BDQualifier;
@class MCHostingNode;


@interface MCStageSyncDaemon : MCDatabaseSyncDaemon {

	NSOperationQueue *syncQueue;

	NSDictionary *entitySyncSettings;
	
	NSUInteger coreCount;
	NSUInteger keepAliveCount;
	NSUInteger incompleteJobCount;
}

@property (readwrite, retain) NSOperationQueue *syncQueue;
@property (nonatomic, retain) NSDictionary *entitySyncSettings;

@property (readonly) NSMutableDictionary *ruleSubstitutionMap; // Subclasses should override, call super and add their own keys

- (NSString *)rulesConfigFilePath;

- (void)syncAllHosts;
- (void)syncForJobID:(NSString *)jobID cloudID:(NSString *)cloudID;

// Subclasses SHOULD override these methods
- (NSString *)stageSchemaCreationScript;
- (NSString *)stagePostProcessingScript;
- (BOOL)shouldProcessRule:(MCExportRule *)rule; // defaults to YES
- (void)configureSyncDefaultsForClientStage:(MCClientStage *)stage;
- (BDQualifier *)qualifierForUserOwnedObjectsForEntity:(MCPEntity *)anEntity;
- (NSString *)processIdentifier;
- (void)jobFinished:(MCSyncHost *)host;
- (void)singleJobFinished:(MCSyncHost *)host;

@end
